﻿package  
{
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.display.Bitmap;
	import flash.display.Shader;
	import flash.display.Sprite;
	import flash.filters.ShaderFilter;
	/**
	 * http://en.nicoptere.net/
	 * @author nicoptere
	 */
	public class BasicPRY extends Sprite
	{
		private var stopped:Boolean = true;
		private var photo:Bitmap;
		[Embed(source = 'equirectangular_pano.jpg')]private var img:Class;
		private var shader:Shader;
		[Embed(source = "PRYprojection.pbj", mimeType = "application/octet-stream")]private var PRY:Class;
		public function BasicPRY() 
		{
			//creates a picture
			photo = new img() as Bitmap;
			addChild( photo );
			//creates the shader
			shader = new Shader(  new PRY() );
			shader.data.imageSize.value = [ photo.width, photo.height ];
			//update
			stage.addEventListener( Event.ENTER_FRAME, applyFilter );
			stage.addEventListener( MouseEvent.CLICK, startStop );	
		}
		private function applyFilter( evt:Event ):void
		{
			if ( stopped ) return;
			var w:Number = stage.stageWidth;
			var h:Number = stage.stageHeight;
			var P:Number = ( h / 2 - mouseY ) / h  * 360;
			var R:Number = 0;
			var Y:Number = ( w / 2 - mouseX ) / w  * 360;
			shader.data.rotation.value = [ P, R, Y ];
			photo.filters = [ new ShaderFilter( shader ) ];
		}
		private function startStop( e:MouseEvent ):void { stopped = ( !stopped ) ? true : false; }
	}
}